/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.sdgraph;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.sdgraph.AbstractSdgEdge;
import cz.insophy.inplan.sdgraph.EdgeMaker;
import cz.insophy.inplan.sdgraph.SdgEdgeImpl;
import cz.insophy.inplan.sdgraph.SdgNode;
import cz.insophy.inplan.sdgraph.StoreDependencyGraphBuilder;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import cz.insophy.inplan.superplan.ProductionTreeNode;
import cz.insophy.inplan.util.Tuple;
import java.util.Comparator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

abstract class SaEdgeMaker
extends EdgeMaker {
    private int edgeOrderKey;

    SaEdgeMaker(StoreDependencyGraphBuilder b) {
        super(b);
    }

    @Override
    protected void makeEdges() {
        Iterable materials = this.superplan.getShopConf().getMatprods().stream().filter(Material::isConsumed).sorted(Comparator.comparing(Material::getId))::iterator;
        for (Material mat : materials) {
            Tuple<Iterable<StoreActivity>, Iterable<StoreActivity>> acts = this.collectActivities(mat);
            this.pairActivities(acts.getFirst(), acts.getSecond());
        }
    }

    protected abstract Tuple<Iterable<StoreActivity>, Iterable<StoreActivity>> collectActivities(Material var1);

    private void pairActivities(Iterable<StoreActivity> srcSas, Iterable<StoreActivity> dstSas) {
        Iterator<StoreActivity> srcIter = srcSas.iterator();
        Iterator<StoreActivity> dstIter = dstSas.iterator();
        double srcQty = 0.0;
        double dstQty = 0.0;
        StoreActivity src = null;
        StoreActivity dst = null;
        while (true) {
            if (srcQty <= 1.0E-7) {
                if (srcIter.hasNext()) {
                    src = srcIter.next();
                    srcQty = src.getQty();
                } else {
                    src = null;
                }
            }
            if (dstQty <= 1.0E-7) {
                if (dstIter.hasNext()) {
                    dst = dstIter.next();
                    dstQty = dst.getAbsQty();
                } else {
                    dst = null;
                }
            }
            if (src == null || dst == null) break;
            double qty = Math.min(srcQty, dstQty);
            srcQty -= qty;
            dstQty -= qty;
            this.addEdge(src, dst, qty);
        }
        if (src != null) {
            this.addEdge(src, null, srcQty);
        }
        while (srcIter.hasNext()) {
            src = srcIter.next();
            this.addEdge(src, null, src.getQty());
        }
    }

    protected void addEdge(@Nonnull StoreActivity source, @Nullable StoreActivity destination, double qty) {
        AbstractSdgEdge edge = this.createEdgeFromSas(source, destination, qty);
        if (edge != null) {
            this.b.addEdge(edge);
        }
    }

    @Nullable
    protected AbstractSdgEdge createEdgeFromSas(@Nonnull StoreActivity source, @Nullable StoreActivity destination, double qty) {
        Preconditions.checkArgument(destination == null || source.getMaterial().equals(destination.getMaterial()));
        Material mat = source.getMaterial();
        SdgNode sourceNode = this.toSdgNode(source, mat);
        SdgNode destinationNode = this.toSdgNode(destination, mat);
        if (sourceNode == destinationNode) {
            return null;
        }
        return new SdgEdgeImpl(this.edgeOrderKey++, sourceNode, destinationNode, source, destination, qty);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SdgNode toSdgNode(@Nullable StoreActivity sa, @Nonnull Material mat) {
        if (sa == null) {
            return this.b.getMaterialNode(mat);
        }
        if (sa instanceof ExternalStoreActivity) {
            return this.b.getEsaNode((ExternalStoreActivity)sa);
        }
        Object orig = sa.getOriginator();
        if (orig instanceof ProductionTreeNode) {
            if (this.nodeMode == StoreDependencyGraphBuilder.NodeMode.GAR) {
                if (orig instanceof ActionActivity) {
                    return this.b.getGarNode(((ActionActivity)orig).getGar());
                }
                if (!(orig instanceof GeneralizedActionRequest)) throw new IllegalStateException("Unsupported SA originator " + orig + " of " + sa);
                return this.b.getGarNode((GeneralizedActionRequest)orig);
            }
            if (this.nodeMode != StoreDependencyGraphBuilder.NodeMode.GOR) throw new IllegalStateException("Unsupported nodeMode " + this.nodeMode);
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor((ProductionTreeNode)orig);
            return this.b.getGorNode(gor);
        }
        if (orig instanceof CustomerRequest) {
            return this.b.getCrNode((CustomerRequest)orig);
        }
        if (!(orig instanceof SupplyRequest)) throw new IllegalStateException("Unsupported SA originator " + orig + " of " + sa);
        return this.b.getSrNode((SupplyRequest)orig);
    }
}

